#adjust this to the folder that contains data files
setwd("/Users/ding/Documents/R/Main")

# transfer all the output to a file.
sink("output_mainstudy_dataPreparationII", split = "TRUE")
R.version.string
sessionInfo()
# for more information, use R.Version()

cat("\n###############################################################################\n")
cat("\n# Data preparation I for the paper for International Journal of Human-Computer Studies: Virtual reality negotiation training system with exposure to simulated thoughts and conversations: Design and evaluation\n")
cat("\n# 2018 TUDelft\n")
cat("\n# Output file: output_mainstudy_dataPreparationII.txt will be created \n")
cat("\n# Author: Ding Ding \n")
cat("\n# required datafile\n")
cat("\n# - DemographicData.csv\n")
cat("\n# - SE_intermediate measurement I.csv\n")
cat("\n# - SE_intermediate measurement II.csv\n")
cat("\n# - Post_waitinglist.csv\n")
cat("\n# - SE_Pre measurement.csv\n")
cat("\n# - SE_post measurement.csv\n")
cat("\n# - SE_Follow-up measurement.csv\n")
cat("\n# - NegotiationBehaviour_Pre.csv\n")
cat("\n# - NegotiationBehaviour_Post.csv\n")
cat("\n# - NegotiationBehaviour_follow.csv\n")
cat("\n# - NegotiationBehaviour_PostWL.csv\n")
cat("\n# - NegotiationKnowledge_Pre.csv\n")
cat("\n# - NegotiationKnowledge_Post.csv\n")
cat("\n# - NegotiationKnowledge_follow.csv\n")
cat("\n# - NegotiationKnowledge_PostWL.csv\n")
cat("\n# - Utility_post measurement.csv\n")
cat("\n# - Self-esteem.csv\n")
cat("\n###############################################################################\n")

#################### Demographic data
# File with Demographic data of all participants
# Data orignally obtained from DemographicData.csv
# ID_mainpre: participants' ID
# Gender: Male or Female
# Age: participants' age
# VRexperience: Yes, no or maybe

Demography <- read.csv("DemographicData.csv", header = TRUE)
colnames(Demography) <- c("ID","Gender","Age", "VRexperience")
Demography$ID<- as.numeric(as.character(Demography$ID))
DemographyData<- Demography[order(Demography$ID),]

DemographyData$Group<-as.vector("N")
i<-1
ID<-as.vector(DemographyData$ID)
length(ID)
while (i <= length(ID)) {
  if(ID[i] == 1||ID[i] ==7||ID[i] == 12||ID[i] == 13||ID[i] ==18||ID[i] == 23||ID[i] == 28||ID[i] ==32||ID[i] == 36||ID[i] == 38||ID[i] ==44||ID[i] == 45) {  
    DemographyData$Group[i]<-"WLWS"
  }
  if(ID[i] == 4||ID[i] ==5||ID[i] == 11||ID[i] == 15||ID[i] ==20||ID[i] == 21||ID[i] == 27||ID[i] ==31||ID[i] == 33||ID[i] == 40||ID[i] ==43||ID[i] == 48) {  
    DemographyData$Group[i]<-"WLWOS"
  }
  if(ID[i] == 3||ID[i] ==6|ID[i] == 10||ID[i] == 16||ID[i] ==17||ID[i] == 22||ID[i] == 26||ID[i] ==29||ID[i] == 35||ID[i] == 37||ID[i] ==41||ID[i] == 47) {  
    DemographyData$Group[i]<-"EWOS"
  }
  if(ID[i] == 2||ID[i] ==8||ID[i] == 9||ID[i] == 14||ID[i] ==19||ID[i] == 24||ID[i] == 25||ID[i] ==30||ID[i] == 34||ID[i] == 39||ID[i] ==42||ID[i] == 46) {  
    DemographyData$Group[i]<-"EWS"
  }
  i <- i+1
}

write.csv(DemographyData,"DemographyData.csv",row.names=FALSE)

#################### Self-efficacy
# File with self-efficacy data of all participants of pre-measurement, the first intermediate measurement, the second intermediate measurement, post-measurement, post-measurement of waitinglist and follow-up measurement

### SE_intermediate measurement II.csv
# File with self-efficacy data of all participants after the first training session
# SE_SessionI: The self-efficacy data after the first training session in the seuquence of ID
SessionI <- read.csv("SE_intermediate measurement I.csv", header = TRUE)
colnames(SessionI)[1] <- "ID"
SessionI$ID<- as.numeric(as.character(SessionI$ID))
SE_SessionI <- SessionI[order(SessionI$ID),]

### SE_intermediate measurement II.csv
# File with self-efficacy data from all participants after the second training session
# SE_SessionII: The self-efficacy data after the second training session in the seuquence of ID
SessionII <- read.csv("SE_intermediate measurement II.csv", header = TRUE)
colnames(SessionII)[1] <- "ID"
SessionII$ID<- as.numeric(as.character(SessionII$ID))
SE_SessionII <- SessionII[order(SessionII$ID),]

### Post_waitinglist.csv
# File with post measurement self-efficacy data of waitinglist group participants
# SE_PostWL: post measurement self-efficacy data of waitinglist group participants in the seuquence of ID
Post_measurementWL <- read.csv("Post_waitinglist.csv", header = TRUE)
colnames(Post_measurementWL)[1] <- "ID"
Post_measurementWL$ID<- as.numeric(as.character(Post_measurementWL$ID))
SE_PostWL<- Post_measurementWL[order(Post_measurementWL$ID),]

### SE_post measurement.csv
# File with post measurement self-efficacy data of all participants
# SE_Post: post measurement self-efficacy data of all participants in the seuquence of ID
# SE_PostEX: post measurement self-efficacy data of participants in experiment group
Post_measurement <- read.csv("SE_post measurement.csv", header = TRUE)
colnames(Post_measurement)[1] <- "ID"
SE_Post<- Post_measurement[order(Post_measurement$ID),]
SE_Post$Group<-as.vector("N")
i<-1
ID<-as.vector(SE_Post$ID)
length(ID)
while (i <= length(ID)) {
  if(ID[i] == 1||ID[i] ==7||ID[i] == 12||ID[i] == 13||ID[i] ==18||ID[i] == 23||ID[i] == 28||ID[i] ==32||ID[i] == 36||ID[i] == 38||ID[i] ==44||ID[i] == 45) {  
    SE_Post$Group[i]<-"WLWS"
  }
  
  if(ID[i] == 4||ID[i] ==5||ID[i] == 11||ID[i] == 15||ID[i] ==20||ID[i] == 21||ID[i] == 27||ID[i] ==31||ID[i] == 33||ID[i] == 40||ID[i] ==43||ID[i] == 48) {  
    SE_Post$Group[i]<-"WLWOS"
  }
  
  if(ID[i] == 3||ID[i] ==6|ID[i] == 10||ID[i] == 16||ID[i] ==17||ID[i] == 22||ID[i] == 26||ID[i] ==29||ID[i] == 35||ID[i] == 37||ID[i] ==41||ID[i] == 47) {  
    SE_Post$Group[i]<-"EWOS"
  }
  
  if(ID[i] == 2||ID[i] ==8||ID[i] == 9||ID[i] == 14||ID[i] ==19||ID[i] == 24||ID[i] == 25||ID[i] ==30||ID[i] == 34||ID[i] == 39||ID[i] ==42||ID[i] == 46) {  
    SE_Post$Group[i]<-"EWS"
  }
  i <- i+1
}
SE_PostEX<-subset(SE_Post,Group=="EWOS" |Group=="EWS" )
SE_PostEWOS<-subset(SE_Post,Group=="EWOS")
SE_PostEWS<-subset(SE_Post,Group=="EWS" )

describe(SE_PostEWOS)
describe(SE_PostEWS)

### SE_Pre measurement.csv
# File with post-measurement self-efficacy data of all participants
# SE_Pre: pre-measurement self-efficacy data of all participants at the very begining in the seuquence of ID
# SE_PreWL:pre-measurement self-efficacy data of the participants in waitinglist group
# SE_PreEX:pre-measurement self-efficacy data of the participants in experiment group
# SE_PreALL:pre-measurement self-efficacy data of all participants joined the experiment in sequence

Pre_measurement<- read.csv("SE_Pre measurement.csv", header = TRUE)
colnames(Pre_measurement)[1] <- "ID"
SE_Pre<- Pre_measurement[order(Pre_measurement$ID),]
SE_Pre$Group<-as.vector("N")
i<-1
ID<-as.vector(SE_Pre$ID)
length(ID)
while (i <= length(ID)) {
  if(ID[i] == 1||ID[i] ==7||ID[i] == 12||ID[i] == 13||ID[i] ==18||ID[i] == 23||ID[i] == 28||ID[i] ==32||ID[i] == 36||ID[i] == 38||ID[i] ==44||ID[i] == 45) {  
    SE_Pre$Group[i]<-"WLWS"
  }
  
  if(ID[i] == 4||ID[i] ==5||ID[i] == 11||ID[i] == 15||ID[i] ==20||ID[i] == 21||ID[i] == 27||ID[i] ==31||ID[i] == 33||ID[i] == 40||ID[i] ==43||ID[i] == 48) {  
    SE_Pre$Group[i]<-"WLWOS"
  }
  
  if(ID[i] == 3||ID[i] ==6|ID[i] == 10||ID[i] == 16||ID[i] ==17||ID[i] == 22||ID[i] == 26||ID[i] ==29||ID[i] == 35||ID[i] == 37||ID[i] ==41||ID[i] == 47) {  
    SE_Pre$Group[i]<-"EWOS"
  }
  
  if(ID[i] == 2||ID[i] ==8||ID[i] == 9||ID[i] == 14||ID[i] ==19||ID[i] == 24||ID[i] == 25||ID[i] ==30||ID[i] == 34||ID[i] == 39||ID[i] ==42||ID[i] == 46) {  
    SE_Pre$Group[i]<-"EWS"
  }
  i <- i+1
}

SE_Pre_WL<-subset(SE_Pre,Group=="WLWS" |Group=="WLWOS" )
SE_Pre_EX<-subset(SE_Pre,Group=="EWOS" |Group=="EWS" )
SE_PreEWOS<-subset(SE_Pre,Group=="EWOS")
SE_PreEWS<-subset(SE_Pre,Group=="EWS")

SE_PreEWS$SE<-as.numeric(as.character(SE_PreEWS$SE))
SE_PreEWOS$SE<-as.numeric(as.character(SE_PreEWOS$SE))
SE_WL$Pre<-as.numeric(as.character(SE_WL$Pre))

SE_PreEX<-SE_Pre_EX[,c(1:2)]
SE_PreWL<-SE_Pre_WL[,c(1:2)]
SE_Pre_ALL<- rbind(SE_PreEX,SE_PostWL)
SE_PreALL<- SE_Pre_ALL[order(SE_Pre_ALL$ID),]

# SE_WL: the self-efficacy data of pre and post measurement of the participants from waitinglist group
# Pre_PostEX: the self-efficacy data of pre and post measurement of the participants from experiment group

SE_WL<-merge(SE_PreWL,SE_PostWL,by=c("ID"))
SE_WL$Group<-"WL"
colnames(SE_WL) <- c("ID","Pre","Post","Group")
SE_WL$Post<-as.numeric(as.character(SE_WL$Post))
SE_WL$Pre<-as.numeric(as.character(SE_WL$Pre))
SE_PreEX$SE<-as.numeric(as.character(SE_PreEX$SE))
SE_PostEX$SE3<-as.numeric(as.character(SE_PostEX$SE3))
SE_EX<-merge(SE_PreEX,SE_PostEX,by=c("ID"))
colnames(SE_EX) <- c("ID","Pre", "Post","Group")

write.csv(SE_WL,"SE_WL.csv",row.names=FALSE)
write.csv(SE_EX,"SE_EX.csv",row.names=FALSE)

WL_EX<-rbind(SE_WL,SE_EX)
SE_WL_EX<- WL_EX[order(WL_EX$ID),]
SE_WLEXFormalized<-melt(SE_WL_EX, id=(c("ID","Group")))
colnames(SE_WLEXFormalized, do.NULL = TRUE)
colnames(SE_WLEXFormalized) <- c("ID","Group","Session", "Score")
colnames(SE_WLEXFormalized, do.NULL = TRUE)
SE_WLEXFormalized$Score<-as.numeric(as.character(SE_WLEXFormalized$Score))

write.csv(SE_WLEXFormalized,"SE_CompareWL&EX.csv",row.names=FALSE)

### SE_Follow-up measurement.csv
FollowUp <- read.csv("SE_Follow-up measurement.csv", header = TRUE)
colnames(FollowUp)[1] <- "ID"
SE_FollowUp <- FollowUp[order(FollowUp$ID),]

### Self-efficacy of all sessions
total <-merge(SE_PreALL,SE_SessionI,by=c("ID"))
Total <-merge(total,SE_SessionII, by=c("ID"))
SE_All <-merge(Total,SE_Post, by=c("ID"))
SE_Withfollow<-merge(SE_All,SE_FollowUp, by=c("ID"), all = TRUE)
SE_Withfollow$Group<-as.vector("M")
i<-1
ID<-as.vector(SE_Withfollow$ID)
length(ID)
while (i <= length(ID)) {
  if(ID[i] == 1||ID[i] ==7||ID[i] == 12||ID[i] == 13||ID[i] ==18||ID[i] == 23||ID[i] == 28||ID[i] ==32||ID[i] == 36||ID[i] == 38||ID[i] ==44||ID[i] == 45||ID[i] == 2||ID[i] ==8||ID[i] == 9||ID[i] == 14||ID[i] ==19||ID[i] == 24||ID[i] == 25||ID[i] ==30||ID[i] == 34||ID[i] == 39||ID[i] ==42||ID[i] == 46) {  
    print(ID[i])
    SE_Withfollow$Group[i]<-"WS"
  }
  
  if(ID[i] == 4||ID[i] ==5||ID[i] == 11||ID[i] == 15||ID[i] ==20||ID[i] == 21||ID[i] == 27||ID[i] ==31||ID[i] == 33||ID[i] == 40||ID[i] ==43||ID[i] == 48||ID[i] == 3||ID[i] ==6|ID[i] == 10||ID[i] == 16||ID[i] ==17||ID[i] == 22||ID[i] == 26||ID[i] ==29||ID[i] == 35||ID[i] == 37||ID[i] ==41||ID[i] == 47) {  
    print(ID[i])
    SE_Withfollow$Group[i]<-"WOS"
  }
  i <- i+1
}
# self-efficacy change comparasion between with self-motivation group and without self-motivation group

write.csv(SE_Withfollow,"SE_With aLL sessions.csv",row.names=FALSE)


#################### Negotiation Behaviour
# File with negotiation behaviour data from all participants 
# NegoBehaviourReordered_Pre : The negotiation behaviour data before the training session in the seuquence of ID
# NegoBehaviourReordered_Post : The negotiation behaviour data after the training session in the seuquence of ID
# NegoBehaviourReordered_follow : The negotiation behaviour data of follow-up measurement in the seuquence of ID
# NegoBehaviourReordered_PostWL : The negotiation behaviour data of waitingList group after the traininng session in the seuquence of ID

NegoBehaviour_Pre<- read.csv("NegotiationBehaviour_Pre.csv", header = TRUE)
colnames(NegoBehaviour_Pre)[1] <- "ID"
NegoBehaviour_Pre$ID<- as.numeric(as.character(NegoBehaviour_Pre$ID))
NegoBehaviourReordered_Pre <- NegoBehaviour_Pre[order(NegoBehaviour_Pre$ID),]

NegoBehaviour_Post<- read.csv("NegotiationBehaviour_Post.csv", header = TRUE)
colnames(NegoBehaviour_Post)[1] <- "ID"
NegoBehaviour_Post$ID<- as.numeric(as.character(NegoBehaviour_Post$ID))
NegoBehaviourReordered_Post <- NegoBehaviour_Post[order(NegoBehaviour_Post$ID),]

NegoBehaviour_follow<- read.csv("NegotiationBehaviour_follow.csv", header = TRUE)
colnames(NegoBehaviour_follow)[1] <- "ID"
NegoBehaviour_follow$ID<- as.numeric(as.character(NegoBehaviour_follow$ID))
NegoBehaviourReordered_follow <- NegoBehaviour_follow[order(NegoBehaviour_follow$ID),]

NegoBehaviour_PostWL<- read.csv("NegotiationBehaviour_PostWL.csv", header = TRUE)
colnames(NegoBehaviour_PostWL)[1] <- "ID"
NegoBehaviour_PostWL$ID<- as.numeric(as.character(NegoBehaviour_PostWL$ID))
NegoBehaviourReordered_PostWL <- NegoBehaviour_PostWL[order(NegoBehaviour_PostWL$ID),]

Satisfaction_PostWL<-subset(NegoBehaviourReordered_PostWL,select=c(1:5))
alpha(Satisfaction_PostWL[2:5]) #Reliability
Satisfaction_PostWL$Mean<-rowMeans(Satisfaction_PostWL[2:5])
SA_PostWL<-subset(Satisfaction_PostWL,select=c(1,6))

NegoFrequence_PostWL<-subset(NegoBehaviourReordered_PostWL,select=c(1,6:9))
NegoFrequence_PostWL$Sum<-rowSums(NegoFrequence_PostWL[2:5])
NegoF_PostWL<-subset(NegoFrequence_PostWL,select=c(1,6))

NegotiationResult_PostWL<-subset(NegoBehaviourReordered_PostWL,select=c(1,10:11))
alpha(NegotiationResult_PostWL[2:3]) #Reliability
NegotiationResult_PostWL$Mean<-rowMeans(NegotiationResult_PostWL[2:3])
NegoResult_PostWL<-subset(NegotiationResult_PostWL,select=c(1,4))

NegoBehaviourReordered_Pre$Group<-as.vector("N")
NegoBehaviourReordered_Post$Group<-as.vector("N")
#NegoBehaviourReordered_follow$Group<-as.vector("N")
i<-1
ID<-as.vector(NegoBehaviourReordered_Pre$ID)
length(ID)
while (i <= length(ID)) {
  if(ID[i] == 1||ID[i] ==7||ID[i] == 12||ID[i] == 13||ID[i] ==18||ID[i] == 23||ID[i] == 28||ID[i] ==32||ID[i] == 36||ID[i] == 38||ID[i] ==44||ID[i] == 45) {  
    NegoBehaviourReordered_Pre$Group[i]<-"WLWS"
    NegoBehaviourReordered_Post$Group[i]<-"WLWS"
    #NegoBehaviourReordered_follow$Group[i]<-"WLWS"
  }
  if(ID[i] == 4||ID[i] ==5||ID[i] == 11||ID[i] == 15||ID[i] ==20||ID[i] == 21||ID[i] == 27||ID[i] ==31||ID[i] == 33||ID[i] == 40||ID[i] ==43||ID[i] == 48) {  
    NegoBehaviourReordered_Pre$Group[i]<-"WLWOS"
    NegoBehaviourReordered_Post$Group[i]<-"WLWOS"
    #NegoBehaviourReordered_follow$Group[i]<-"WLWOS"
  }
  if(ID[i] == 3||ID[i] ==6|ID[i] == 10||ID[i] == 16||ID[i] ==17||ID[i] == 22||ID[i] == 26||ID[i] ==29||ID[i] == 35||ID[i] == 37||ID[i] ==41||ID[i] == 47) {  
    NegoBehaviourReordered_Pre$Group[i]<-"EWOS"
    NegoBehaviourReordered_Post$Group[i]<-"EWOS"
    #NegoBehaviourReordered_follow$Group[i]<-"EWOS"
  }
  if(ID[i] == 2||ID[i] ==8||ID[i] == 9||ID[i] == 14||ID[i] ==19||ID[i] == 24||ID[i] == 25||ID[i] ==30||ID[i] == 34||ID[i] == 39||ID[i] ==42||ID[i] == 46) {  
    NegoBehaviourReordered_Pre$Group[i]<-"EWS"
    NegoBehaviourReordered_Post$Group[i]<-"EWS"
    #NegoBehaviourReordered_follow$Group[i]<-"EWS"
  }
  i <- i+1
}

Satisfaction_Pre<-subset(NegoBehaviourReordered_Pre,select=c(1:5,Group))
Satisfaction_Post<-subset(NegoBehaviourReordered_Post,select=c(1:5,Group))
Satisfaction_follow<-subset(NegoBehaviourReordered_follow,select=c(1:5))
alpha(Satisfaction_Pre[2:5]) 
alpha(Satisfaction_Post[2:5]) 
alpha(Satisfaction_follow[2:5]) 
Satisfaction_Pre$Mean<-rowMeans(Satisfaction_Pre[2:5])
Satisfaction_PreWL<-subset(Satisfaction_Pre,Group=="WLWS" |Group=="WLWOS" )
SA_PreWL<-subset(Satisfaction_PreWL,select=c(1,7))
Satisfaction_PreEX<-subset(Satisfaction_Pre,Group=="EWOS" |Group=="EWS" )
SA_PreEX<-subset(Satisfaction_PreEX,select=c(1,6,7))
Satisfaction_PreEWOS<-subset(Satisfaction_Pre,Group=="EWOS")
Satisfaction_PreEWS<-subset(Satisfaction_Pre,Group=="EWS")

Satisfaction_Post$Mean<-rowMeans(Satisfaction_Post[2:5])
Satisfaction_PostEX<-subset(Satisfaction_Post,Group=="EWOS" |Group=="EWS" )
SA_PostEX<-subset(Satisfaction_PostEX,select=c(1,6,7))
SA_Post<-subset(Satisfaction_Post,select=c(1,7))

Satisfaction_follow$Mean<-rowMeans(Satisfaction_follow[2:5])
SA_follow<-subset(Satisfaction_follow,select=c(1,6))
SA_followReordered<- SA_follow[order(SA_follow$ID),]

SA_WL<-merge(SA_PreWL,SA_PostWL,by=c("ID"))
SA_WL$Group<-"WL"
colnames(SA_WL) <- c("ID","Pre","Post","Group")
SA_WL$Post<-as.numeric(as.character(SA_WL$Post))
SA_WL$Pre<-as.numeric(as.character(SA_WL$Pre))

SA_PreEX$Mean<-as.numeric(as.character(SA_PreEX$Mean))
SA_PostEX$Mean<-as.numeric(as.character(SA_PostEX$Mean))
SA_EX<-merge(SA_PreEX,SA_PostEX,by=c("ID","Group"))
colnames(SA_EX) <- c("ID","Group","Pre", "Post")
SA_EWOS<-subset(SA_EX,Group=="EWOS")
SA_EWS<-subset(SA_EX,Group=="EWS")

write.csv(SA_WL,"SA_WL.csv",row.names=FALSE)
write.csv(SA_EX,"SA_EX.csv",row.names=FALSE)

SA_WLplusEX<-rbind(SA_WL,SA_EX)
SA_WLplusEXReordered<- SA_WLplusEX[order(SA_WLplusEX$ID),]
SA_WLEXFormalized<-melt(SA_WLplusEXReordered, id=(c("ID","Group")))
colnames(SA_WLEXFormalized, do.NULL = TRUE)
colnames(SA_WLEXFormalized) <- c("ID","Group","Session", "Score")
colnames(SA_WLEXFormalized, do.NULL = TRUE)
SA_WLEXFormalized$Score<-as.numeric(as.character(SA_WLEXFormalized$Score))
write.csv(SA_WLEXFormalized,"SA_CompareWL&EX.csv",row.names=FALSE)

SA_PreALL<- rbind(SA_PreEX[c(1,3)],SA_PostWL)
SA_PreALLReordered<- SA_PreALL[order(SA_PreALL$ID),]
SA_PrePlusPost <-merge(SA_PreALLReordered,SA_Post,by=c("ID"))
SA_ALL <-merge(SA_PrePlusPost,SA_followReordered, by=c("ID"),all = TRUE)
SA_ALL$Group<-as.vector("NA")
i<-1
ID<-as.vector(SA_ALL$ID)
length(ID)
while (i <= length(ID)) {
  if(ID[i] == 1||ID[i] ==7||ID[i] == 12||ID[i] == 13||ID[i] ==18||ID[i] == 23||ID[i] == 28||ID[i] ==32||ID[i] == 36||ID[i] == 38||ID[i] ==44||ID[i] == 45||ID[i] == 2||ID[i] ==8||ID[i] == 9||ID[i] == 14||ID[i] ==19||ID[i] == 24||ID[i] == 25||ID[i] ==30||ID[i] == 34||ID[i] == 39||ID[i] ==42||ID[i] == 46) {  
    SA_ALL$Group[i]<-"WS"
  }
  
  if(ID[i] == 4||ID[i] ==5||ID[i] == 11||ID[i] == 15||ID[i] ==20||ID[i] == 21||ID[i] == 27||ID[i] ==31||ID[i] == 33||ID[i] == 40||ID[i] ==43||ID[i] == 48||ID[i] == 3||ID[i] ==6|ID[i] == 10||ID[i] == 16||ID[i] ==17||ID[i] == 22||ID[i] == 26||ID[i] ==29||ID[i] == 35||ID[i] == 37||ID[i] ==41||ID[i] == 47) {  
    SA_ALL$Group[i]<-"WOS"
  }
  i <- i+1
}

colnames(SA_ALL) <- c("ID","Pre","Post","FollowUp","Group")
write.csv(SA_ALL,"SA_ALL.csv",row.names=FALSE)

NegoFrequence_Pre<-subset(NegoBehaviourReordered_Pre,select=c(1,6:9,Group))
NegoFrequence_Pre$Sum<-rowSums(NegoFrequence_Pre[2:5])
NegoFrequence_Post<-subset(NegoBehaviourReordered_Post,select=c(1,6:9,Group))
NegoFrequence_Post$Sum<-rowSums(NegoFrequence_Post[2:5])
NegoFrequence_follow<-subset(NegoBehaviourReordered_follow,select=c(1,6:9))
NegoFrequence_follow$Sum<-rowSums(NegoFrequence_follow[2:5])

NegoFrequence_PreWL<-subset(NegoFrequence_Pre,Group=="WLWS" |Group=="WLWOS" )
NegoF_PreWL<-subset(NegoFrequence_PreWL,select=c(1,7))
NegoFrequence_PreEX<-subset(NegoFrequence_Pre,Group=="EWOS" |Group=="EWS" )
NegoF_PreEX<-subset(NegoFrequence_PreEX,select=c(1,6,7))
NegoFrequence_PreEWOS<-subset(NegoFrequence_Pre,Group=="EWOS")
NegoFrequence_PreEWS<-subset(NegoFrequence_Pre,Group=="EWS")

NegoFrequence_PostEX<-subset(NegoFrequence_Post,Group=="EWOS" |Group=="EWS" )
NegoF_PostEX<-subset(NegoFrequence_PostEX,select=c(1,6,7))
NegoF_Post<-subset(NegoFrequence_Post,select=c(1,7))

NegoF_follow<-subset(NegoFrequence_follow,select=c(1,6))
NegoF_followReordered<- NegoF_follow[order(NegoF_follow$ID),]

NegoF_WL<-merge(NegoF_PreWL,NegoF_PostWL,by=c("ID"))
NegoF_WL$Group<-"WL"
colnames(NegoF_WL) <- c("ID","Pre","Post","Group")
NegoF_WL$Post<-as.numeric(as.character(NegoF_WL$Post))
NegoF_WL$Pre<-as.numeric(as.character(NegoF_WL$Pre))

NegoF_PreEX$Sum<-as.numeric(as.character(NegoF_PreEX$Sum))
NegoF_PostEX$Sum<-as.numeric(as.character(NegoF_PostEX$Sum))
NegoF_EX<-merge(NegoF_PreEX,NegoF_PostEX,by=c("ID","Group"))
colnames(NegoF_EX) <- c("ID","Group","Pre", "Post")
NegoF_EWOS<-subset(NegoF_EX,Group=="EWOS")
NegoF_EWS<-subset(NegoF_EX,Group=="EWS")

write.csv(NegoF_EX,"NegoF_EX.csv",row.names=FALSE)
write.csv(NegoF_WL,"NegoF_WL.csv",row.names=FALSE)

NegoF_WLplusEX<-rbind(NegoF_WL,NegoF_EX)
NegoF_WLplusEXReordered<- NegoF_WLplusEX[order(NegoF_WLplusEX$ID),]
NegoF_WLEXFormalized<-melt(NegoF_WLplusEXReordered, id=(c("ID","Group")))
colnames(NegoF_WLEXFormalized, do.NULL = TRUE)
colnames(NegoF_WLEXFormalized) <- c("ID","Group","Session", "Score")
colnames(NegoF_WLEXFormalized, do.NULL = TRUE)
NegoF_WLEXFormalized$Score<-as.numeric(as.character(NegoF_WLEXFormalized$Score))
write.csv(NegoF_WLEXFormalized,"NegoF_CompareWL&EX.csv",row.names=FALSE)

NegoF_PreALL<- rbind(NegoF_PreEX[c(1,3)],NegoF_PostWL)
NegoF_PreALLReordered<- NegoF_PreALL[order(NegoF_PreALL$ID),]
NegoF_PrePlusPost <-merge(NegoF_PreALLReordered,NegoF_Post,by=c("ID"))
NegoF_ALL <-merge(NegoF_PrePlusPost,NegoF_followReordered, by=c("ID"),all = TRUE)
NegoF_ALL$Group<-as.vector("NA")
i<-1
ID<-as.vector(NegoF_ALL$ID)
length(ID)
while (i <= length(ID)) {
  if(ID[i] == 1||ID[i] ==7||ID[i] == 12||ID[i] == 13||ID[i] ==18||ID[i] == 23||ID[i] == 28||ID[i] ==32||ID[i] == 36||ID[i] == 38||ID[i] ==44||ID[i] == 45||ID[i] == 2||ID[i] ==8||ID[i] == 9||ID[i] == 14||ID[i] ==19||ID[i] == 24||ID[i] == 25||ID[i] ==30||ID[i] == 34||ID[i] == 39||ID[i] ==42||ID[i] == 46) {  
    NegoF_ALL$Group[i]<-"WS"
  }
  
  if(ID[i] == 4||ID[i] ==5||ID[i] == 11||ID[i] == 15||ID[i] ==20||ID[i] == 21||ID[i] == 27||ID[i] ==31||ID[i] == 33||ID[i] == 40||ID[i] ==43||ID[i] == 48||ID[i] == 3||ID[i] ==6|ID[i] == 10||ID[i] == 16||ID[i] ==17||ID[i] == 22||ID[i] == 26||ID[i] ==29||ID[i] == 35||ID[i] == 37||ID[i] ==41||ID[i] == 47) {  
    NegoF_ALL$Group[i]<-"WOS"
  }
  i <- i+1
}

colnames(NegoF_ALL) <- c("ID","Pre","Post","FollowUp","Group")
write.csv(NegoF_ALL,"NegoF_ALL.csv",row.names=FALSE)

NegoPerformanceWinSuccess_Pre<-subset(NegoBehaviourReordered_Pre,select=c(1,10:11,Group))
alpha(NegoPerformanceWinSuccess_Pre[2:3])
NegoPerformanceWinSuccess_Post<-subset(NegoBehaviourReordered_Post,select=c(1,10:11,Group))
alpha(NegoPerformanceWinSuccess_Post[2:3])
NegoPerformanceWinSuccess_follow<-subset(NegoBehaviourReordered_follow,select=c(1,10:11))
alpha(NegoPerformanceWinSuccess_follow[2:3])

NegoPerformanceWinSuccess_Pre$Mean<-rowMeans(NegoPerformanceWinSuccess_Pre[2:3])
NegoResult_Pre<-subset(NegoPerformanceWinSuccess_Pre,select=c(1,4,5))

NegoPerformanceWinSuccess_Post$Mean<-rowMeans(NegoPerformanceWinSuccess_Post[2:3])
NegoResult_Post<-subset(NegoPerformanceWinSuccess_Post,select=c(1,4,5))

NegoPerformanceWinSuccess_follow$Mean<-rowMeans(NegoPerformanceWinSuccess_follow[2:3])
NegoResult_follow<-subset(NegoPerformanceWinSuccess_follow,select=c(1,4))

NegoResult_PreWL<-subset(NegoResult_Pre,Group=="WLWS" |Group=="WLWOS" )
NegoResult_PreEX<-subset(NegoResult_Pre,Group=="EWOS" |Group=="EWS" )
NegoResult_PreEWOS<-subset(NegoResult_Pre,Group=="EWOS")
NegoResult_PreEWS<-subset(NegoResult_Pre,Group=="EWS")

NegoResult_PostEX<-subset(NegoResult_Post,Group=="EWOS" |Group=="EWS" )

NegoResult_WL<-merge(NegoResult_PreWL,NegoResult_PostWL,by=c("ID"))
NegoResult_WL$Group<-"WL"
colnames(NegoResult_WL) <- c("ID","Group","Pre","Post")
NegoResult_WL$Post<-as.numeric(as.character(NegoResult_WL$Post))
NegoResult_WL$Pre<-as.numeric(as.character(NegoResult_WL$Pre))

NegoResult_PreEX$Mean<-as.numeric(as.character(NegoResult_PreEX$Mean))
NegoResult_PostEX$Mean<-as.numeric(as.character(NegoResult_PostEX$Mean))
NegoResult_EX<-merge(NegoResult_PreEX,NegoResult_PostEX,by=c("ID","Group"))
colnames(NegoResult_EX) <- c("ID","Group","Pre", "Post")
NegoResult_EWOS<-subset(NegoResult_EX,Group=="EWOS")
NegoResult_EWS<-subset(NegoResult_EX,Group=="EWS")

write.csv(NegoResult_EX,"NegoResult_EX.csv",row.names=FALSE)
write.csv(NegoResult_WL,"NegoResult_WL.csv",row.names=FALSE)

NegoResult_WLplusEX<-rbind(NegoResult_WL,NegoResult_EX)
NegoResult_WLplusEXReordered<- NegoResult_WLplusEX[order(NegoResult_WLplusEX$ID),]
NegoResult_WLEXFormalized<-melt(NegoResult_WLplusEXReordered, id=(c("ID","Group")))
colnames(NegoResult_WLEXFormalized, do.NULL = TRUE)
colnames(NegoResult_WLEXFormalized) <- c("ID","Group","Session", "Score")
colnames(NegoResult_WLEXFormalized, do.NULL = TRUE)
NegoResult_WLEXFormalized$Score<-as.numeric(as.character(NegoResult_WLEXFormalized$Score))
write.csv(NegoResult_WLEXFormalized,"NegoResult_CompareWL&EX.csv",row.names=FALSE)

NegoResult_PreALL<- rbind(NegoResult_PreEX[c(1,3)],NegoResult_PostWL)
NegoResult_PreALLReordered<- NegoResult_PreALL[order(NegoResult_PreALL$ID),]
NegoResult_PrePlusPost <-merge(NegoResult_PreALLReordered,NegoResult_Post,by=c("ID"))
NegoResult_ALL <-merge(NegoResult_PrePlusPost,NegoResult_follow, by=c("ID"),all = TRUE)
NegoResult_ALL$Group<-as.vector("NA")
i<-1
ID<-as.vector(NegoResult_ALL$ID)
length(ID)
while (i <= length(ID)) {
  if(ID[i] == 1||ID[i] ==7||ID[i] == 12||ID[i] == 13||ID[i] ==18||ID[i] == 23||ID[i] == 28||ID[i] ==32||ID[i] == 36||ID[i] == 38||ID[i] ==44||ID[i] == 45||ID[i] == 2||ID[i] ==8||ID[i] == 9||ID[i] == 14||ID[i] ==19||ID[i] == 24||ID[i] == 25||ID[i] ==30||ID[i] == 34||ID[i] == 39||ID[i] ==42||ID[i] == 46) {  
    NegoResult_ALL$Group[i]<-"WS"
  }
  
  if(ID[i] == 4||ID[i] ==5||ID[i] == 11||ID[i] == 15||ID[i] ==20||ID[i] == 21||ID[i] == 27||ID[i] ==31||ID[i] == 33||ID[i] == 40||ID[i] ==43||ID[i] == 48||ID[i] == 3||ID[i] ==6|ID[i] == 10||ID[i] == 16||ID[i] ==17||ID[i] == 22||ID[i] == 26||ID[i] ==29||ID[i] == 35||ID[i] == 37||ID[i] ==41||ID[i] == 47) {  
    NegoResult_ALL$Group[i]<-"WOS"
  }
  i <- i+1
}

NegoResult_ALL<-NegoResult_ALL[,c(1,3,2,4,5)]
colnames(NegoResult_ALL) <- c("ID","Group","Pre","Post","FollowUp")
write.csv(NegoResult_ALL,"NegoResult_ALL.csv",row.names=FALSE)


#################### Negotiation Knowledge
# File with negotiation knowledge test scores of all participants before and after the training session
# NegoKnowledgeReordered_Pre: The negotiation knowledge test scores before the training session in the seuquence of ID
# NegoKnowledgeReordered_Post: The negotiation knowledge test scores after the training session in the seuquence of ID
# NegoKnowledgeReordered_follow: The negotiation knowledge test scores of the follow-up measurement in the seuquence of ID
# NegoKnowledgeReordered_PostWL: The negotiation knowledge test scores of the waitlinglist group after the training session in the seuquence of ID

NegoKnowledge_Pre<- read.csv("NegotiationKnowledge_Pre.csv", header = TRUE)
NegoKnowledge_Pre$ID<- as.numeric(as.character(NegoKnowledge_Pre$ID))
NegoKnowledgeReordered_Pre <- NegoKnowledge_Pre[order(NegoKnowledge_Pre$ID),]

NegoKnowledge_Post<- read.csv("NegotiationKnowledge_Post.csv", header = TRUE)
NegoKnowledge_Post$ID<- as.numeric(as.character(NegoKnowledge_Post$ID))
NegoKnowledgeReordered_Post <- NegoKnowledge_Post[order(NegoKnowledge_Post$ID),]

NegoKnowledge_follow<- read.csv("NegotiationKnowledge_follow.csv", header = TRUE)
NegoKnowledge_follow$ID<- as.numeric(as.character(NegoKnowledge_follow$ID))
NegoKnowledgeReordered_follow <- NegoKnowledge_follow[order(NegoKnowledge_follow$ID),]

NegoKnowledge_PostWL<- read.csv("NegotiationKnowledge_PostWL.csv", header = TRUE)
NegoKnowledge_PostWL$ID<- as.numeric(as.character(NegoKnowledge_PostWL$ID))
NegoKnowledgeReordered_PostWL <- NegoKnowledge_PostWL[order(NegoKnowledge_PostWL$ID),]

NegoKnowledgeReordered_Pre$Group<-as.vector("N")
NegoKnowledgeReordered_Post$Group<-as.vector("N")

i<-1
ID<-as.vector(NegoKnowledgeReordered_Pre$ID)
length(ID)
while (i <= length(ID)) {
  if(ID[i] == 1||ID[i] ==7||ID[i] == 12||ID[i] == 13||ID[i] ==18||ID[i] == 23||ID[i] == 28||ID[i] ==32||ID[i] == 36||ID[i] == 38||ID[i] ==44||ID[i] == 45) {  
    NegoKnowledgeReordered_Pre$Group[i]<-"WLWS"
    NegoKnowledgeReordered_Post$Group[i]<-"WLWS"
  }
  if(ID[i] == 4||ID[i] ==5||ID[i] == 11||ID[i] == 15||ID[i] ==20||ID[i] == 21||ID[i] == 27||ID[i] ==31||ID[i] == 33||ID[i] == 40||ID[i] ==43||ID[i] == 48) {  
    NegoKnowledgeReordered_Pre$Group[i]<-"WLWOS"
    NegoKnowledgeReordered_Post$Group[i]<-"WLWOS"
  }
  if(ID[i] == 3||ID[i] ==6|ID[i] == 10||ID[i] == 16||ID[i] ==17||ID[i] == 22||ID[i] == 26||ID[i] ==29||ID[i] == 35||ID[i] == 37||ID[i] ==41||ID[i] == 47) {  
    NegoKnowledgeReordered_Pre$Group[i]<-"EWOS"
    NegoKnowledgeReordered_Post$Group[i]<-"EWOS"
  }
  if(ID[i] == 2||ID[i] ==8||ID[i] == 9||ID[i] == 14||ID[i] ==19||ID[i] == 24||ID[i] == 25||ID[i] ==30||ID[i] == 34||ID[i] == 39||ID[i] ==42||ID[i] == 46) {  
    NegoKnowledgeReordered_Pre$Group[i]<-"EWS"
    NegoKnowledgeReordered_Post$Group[i]<-"EWS"
  }
  i <- i+1
}

NegoKnowledge_PreWL<-subset(NegoKnowledgeReordered_Pre,Group=="WLWS" |Group=="WLWOS" )
NegoKnowledge_PreEX<-subset(NegoKnowledgeReordered_Pre,Group=="EWOS" |Group=="EWS" )
NegoKnowledge_PreEWOS<-subset(NegoKnowledgeReordered_Pre,Group=="EWOS")
NegoKnowledge_PreEWS<-subset(NegoKnowledgeReordered_Pre,Group=="EWS")

NegoKnowledge_PostEWOS<-subset(NegoKnowledgeReordered_Post,Group=="EWOS")
NegoKnowledge_PostEWS<-subset(NegoKnowledgeReordered_Post,Group=="EWS")
NegoKnowledge_PostEX<-subset(NegoKnowledgeReordered_Post,Group=="EWOS" |Group=="EWS" )

NegoKnowledge_WL<-merge(NegoKnowledge_PreWL,NegoKnowledgeReordered_PostWL,by=c("ID"))
NegoKnowledge_WL$Group<-"WL"
colnames(NegoKnowledge_WL) <- c("ID","Pre","Group","Post")
NegoKnowledge_WL$Post<-as.numeric(as.character(NegoKnowledge_WL$Post))
NegoKnowledge_WL$Pre<-as.numeric(as.character(NegoKnowledge_WL$Pre))
NegoKnowledge_EX<-merge(NegoKnowledge_PreEX,NegoKnowledge_PostEX,by=c("ID","Group"))
colnames(NegoKnowledge_EX) <- c("ID","Group","Pre", "Post")
NegoKnowledge_EWOS<-subset(NegoKnowledge_EX,Group=="EWOS")
NegoKnowledge_EWS<-subset(NegoKnowledge_EX,Group=="EWS")
write.csv(NegoKnowledge_EX,"NegoKnowledge_EX.csv",row.names=FALSE)
write.csv(NegoKnowledge_WL,"NegoKnowledge_WL.csv",row.names=FALSE)

NegoKnowledge_WLplusEX<-rbind(NegoKnowledge_EX,NegoKnowledge_WL)
NegoKnowledge_WLplusEXReordered<- NegoKnowledge_WLplusEX[order(NegoKnowledge_WLplusEX$ID),]
NegoKnowledge_WLEXFormalized<-melt(NegoKnowledge_WLplusEXReordered, id=(c("ID","Group")))
colnames(NegoKnowledge_WLEXFormalized, do.NULL = TRUE)
colnames(NegoKnowledge_WLEXFormalized) <- c("ID","Group","Session", "Score")
colnames(NegoKnowledge_WLEXFormalized, do.NULL = TRUE)
NegoKnowledge_WLEXFormalized$Score<-as.numeric(as.character(NegoKnowledge_WLEXFormalized$Score))
write.csv(NegoKnowledge_WLEXFormalized,"NegoKnowledge_CompareWL&EX.csv",row.names=FALSE)

NegoKnowledge_PreALL<- rbind(NegoKnowledge_PreEX[c(1,2)],NegoKnowledge_PostWL)
NegoKnowledge_PreALLReordered<- NegoKnowledge_PreALL[order(NegoKnowledge_PreALL$ID),]
NegoKnowledge_PrePlusPost <-merge(NegoKnowledge_PreALLReordered,NegoKnowledge_Post,by=c("ID"))
NegoKnowledge_ALL <-merge(NegoKnowledge_PrePlusPost,NegoKnowledgeReordered_follow, by=c("ID"),all = TRUE)
NegoKnowledge_ALL$Group<-as.vector("NA")
i<-1
ID<-as.vector(NegoKnowledge_ALL$ID)
length(ID)
while (i <= length(ID)) {
  if(ID[i] == 1||ID[i] ==7||ID[i] == 12||ID[i] == 13||ID[i] ==18||ID[i] == 23||ID[i] == 28||ID[i] ==32||ID[i] == 36||ID[i] == 38||ID[i] ==44||ID[i] == 45||ID[i] == 2||ID[i] ==8||ID[i] == 9||ID[i] == 14||ID[i] ==19||ID[i] == 24||ID[i] == 25||ID[i] ==30||ID[i] == 34||ID[i] == 39||ID[i] ==42||ID[i] == 46) {  
    NegoKnowledge_ALL$Group[i]<-"WS"
  }
  
  if(ID[i] == 4||ID[i] ==5||ID[i] == 11||ID[i] == 15||ID[i] ==20||ID[i] == 21||ID[i] == 27||ID[i] ==31||ID[i] == 33||ID[i] == 40||ID[i] ==43||ID[i] == 48||ID[i] == 3||ID[i] ==6|ID[i] == 10||ID[i] == 16||ID[i] ==17||ID[i] == 22||ID[i] == 26||ID[i] ==29||ID[i] == 35||ID[i] == 37||ID[i] ==41||ID[i] == 47) {  
    NegoKnowledge_ALL$Group[i]<-"WOS"
  }
  i <- i+1
}

colnames(NegoKnowledge_ALL) <- c("ID","Pre","Post","FollowUp","Group")
write.csv(NegoKnowledge_ALL,"NegoKnowledge_ALL.csv",row.names=FALSE)

#################### Utility
# File with utility data of all participants
# Data orignally obtained from Utility_post measurement.csv
# UtilityReordered: The utility data of all participants after the training session in the seuquence of ID

utility<- read.csv("Utility_post measurement.csv", header = TRUE)
colnames(utility) <- c("ID","Q1","Q2", "Q3","Q4","Q5", "Q6","Q7")
utility$ID<- as.numeric(as.character(utility$ID))
UtilityReordered <- utility[order(utility$ID),]

UtilityReordered$Q1<- as.character(UtilityReordered$Q1)
UtilityReordered$Q2<- as.character(UtilityReordered$Q2)
UtilityReordered$Q3<- as.character(UtilityReordered$Q3)
UtilityReordered$Q4<- as.character(UtilityReordered$Q4)
UtilityReordered$Q5<- as.character(UtilityReordered$Q5)
UtilityReordered$Q6<- as.character(UtilityReordered$Q6)
UtilityReordered$Q7<- as.character(UtilityReordered$Q7)

SW <- function(x) {
  switch(x,
         #x<-as.character(x),
         "Strongly agree" = 7,
         "Agree"= 6,
         "Somewhat agree"= 5,
         "Neither agree nor disagree"= 4, 
         "Somewhat disagree"=3,
         "Disagree"=2,
         "Strongly disagree"=1
  )
} 
UtilityReordered$Q1<- sapply(UtilityReordered$Q1, SW)
UtilityReordered$Q2<- sapply(UtilityReordered$Q2, SW)
UtilityReordered$Q3<- sapply(UtilityReordered$Q3, SW)
UtilityReordered$Q4<- sapply(UtilityReordered$Q4, SW)
UtilityReordered$Q5<- sapply(UtilityReordered$Q5, SW)
UtilityReordered$Q6<- sapply(UtilityReordered$Q6, SW)
UtilityReordered$Q7<- sapply(UtilityReordered$Q7, SW)

UtilityReordered$Group<-as.vector("NA")
i<-1
ID<-as.vector(UtilityReordered$ID)
length(ID)
while (i <= length(ID)) {
  if(ID[i] == 1||ID[i] ==7||ID[i] == 12||ID[i] == 13||ID[i] ==18||ID[i] == 23||ID[i] == 28||ID[i] ==32||ID[i] == 36||ID[i] == 38||ID[i] ==44||ID[i] == 45||ID[i] == 2||ID[i] ==8||ID[i] == 9||ID[i] == 14||ID[i] ==19||ID[i] == 24||ID[i] == 25||ID[i] ==30||ID[i] == 34||ID[i] == 39||ID[i] ==42||ID[i] == 46) {  
    UtilityReordered$Group[i]<-"WS"
  }
  
  if(ID[i] == 4||ID[i] ==5||ID[i] == 11||ID[i] == 15||ID[i] ==20||ID[i] == 21||ID[i] == 27||ID[i] ==31||ID[i] == 33||ID[i] == 40||ID[i] ==43||ID[i] == 48||ID[i] == 3||ID[i] ==6|ID[i] == 10||ID[i] == 16||ID[i] ==17||ID[i] == 22||ID[i] == 26||ID[i] ==29||ID[i] == 35||ID[i] == 37||ID[i] ==41||ID[i] == 47) {  
    UtilityReordered$Group[i]<-"WOS"
  }
  i <- i+1
}

write.csv(UtilityReordered,"Utility.csv",row.names=FALSE)


#################### Self-esteem.csv
# File with self-esteem data of all participants before the training session
# ID: participants' ID
# Q1-Q10: pariticipants' self-esteem score for each item

Esteem<- read.csv("Self-esteem.csv", header = TRUE)
colnames(Esteem) <- c("ID","Q1","Q2", "Q3","Q4","Q5", "Q6","Q7","Q8", "Q9","Q10")
Esteem$esteem<-rowSums(Esteem[2:11])
EsteemReordered<- Esteem[order(Esteem$ID),]
SelfEsteem<-subset(EsteemReordered,select=c("ID","esteem"))

## Self-efficacy ~ esteem
EfficacyPlusEsteem<-merge(SE_All,SelfEsteem, by=c("ID"))
EfficacyPlusEsteem_WS<-subset(EfficacyPlusEsteem,Group=="EWS"|Group=="WLWS")
EfficacyPlusEsteem_WS$SEChange<-EfficacyPlusEsteem_WS$SE3-EfficacyPlusEsteem_WS$SE

hist(EfficacyPlusEsteem_WS$SEChange)
hist(EfficacyPlusEsteem_WS$esteem)
stem(EfficacyPlusEsteem_WS$SEChange)
stem(EfficacyPlusEsteem_WS$esteem)
shapiro.test(EfficacyPlusEsteem_WS$SEChange)
shapiro.test(EfficacyPlusEsteem_WS$esteem)

cor.test(EfficacyPlusEsteem_WS$SEChange, EfficacyPlusEsteem_WS$esteem, method = "pearson")
#cor.test(EfficacyPlusEsteem_WS$SEChange, EfficacyPlusEsteem_WS$esteem, method="kendall")
Model<-lm(SEChange~esteem, data=EfficacyPlusEsteem_WS,na.action = na.exclude)
summary(Model)

## knowledge ~ esteem
KnowledgePlusEsteem<-merge(NegoKnowledge_ALL,SelfEsteem, by=c("ID"))
KnowledgePlusEsteem$KnowledgeChange<-KnowledgePlusEsteem$Post-KnowledgePlusEsteem$Pre

hist(KnowledgePlusEsteem$KnowledgeChange)
hist(KnowledgePlusEsteem$esteem)
stem(KnowledgePlusEsteem$KnowledgeChange)
stem(KnowledgePlusEsteem$esteem)
shapiro.test(KnowledgePlusEsteem$KnowledgeChange)
shapiro.test(KnowledgePlusEsteem$esteem)

cor.test(KnowledgePlusEsteem$KnowledgeChange,KnowledgePlusEsteem$esteem, method = "pearson")
Model<-lm(KnowledgeChange~esteem, data=KnowledgePlusEsteem,na.action = na.exclude)
summary(Model)

## NegotiationFrequency ~ esteem
SatisfactionPlusEsteem<-merge(SA_ALL,SelfEsteem, by=c("ID"))
SatisfactionPlusEsteem$SatisfactionChange<-SatisfactionPlusEsteem$Post-SatisfactionPlusEsteem$Pre

hist(SatisfactionPlusEsteem$SatisfactionChange)
hist(SatisfactionPlusEsteem$esteem)
stem(SatisfactionPlusEsteem$SatisfactionChange)
stem(SatisfactionPlusEsteem$esteem)
shapiro.test(SatisfactionPlusEsteem$SatisfactionChange)
shapiro.test(SatisfactionPlusEsteem$esteem)

cor.test(SatisfactionPlusEsteem$SatisfactionChange,SatisfactionPlusEsteem$esteem, method = "pearson")
cor.test(SatisfactionPlusEsteem$SatisfactionChange,SatisfactionPlusEsteem$esteem, method="kendall")
Model<-lm(SatisfactionPlusEsteem$SatisfactionChange~esteem, data=SatisfactionPlusEsteem,na.action = na.exclude)
summary(Model)

## NegotiationSatisfaction ~ esteem
NegoFPlusEsteem<-merge(NegoF_ALL,SelfEsteem, by=c("ID"))
NegoFPlusEsteem$FrequencyChange<-NegoFPlusEsteem$Post-NegoFPlusEsteem$Pre

hist(NegoFPlusEsteem$FrequencyChange)
hist(NegoFPlusEsteem$esteem)
stem(NegoFPlusEsteem$FrequencyChange)
stem(NegoFPlusEsteem$esteem)
shapiro.test(NegoFPlusEsteem$FrequencyChange)
shapiro.test(NegoFPlusEsteem$esteem)

cor.test(NegoFPlusEsteem$FrequencyChange,NegoFPlusEsteem$esteem, method = "pearson")
cor.test(NegoFPlusEsteem$FrequencyChange,NegoFPlusEsteem$esteem, method="kendall")
Model<-lm(FrequencyChange~esteem, data=NegoFPlusEsteem,na.action = na.exclude)
summary(Model)

## NegotiationResult ~ esteem
NegoResulftPlusEsteem<-merge(NegoF_ALL,SelfEsteem, by=c("ID"))
NegoResulftPlusEsteem$ResultChange<-NegoResulftPlusEsteem$Post-NegoResulftPlusEsteem$Pre

hist(NegoResulftPlusEsteem$ResultChange)
hist(NegoResulftPlusEsteem$esteem)
stem(NegoResulftPlusEsteem$ResultChange)
stem(NegoResulftPlusEsteem$esteem)
shapiro.test(NegoResulftPlusEsteem$ResultChange)
shapiro.test(NegoResulftPlusEsteem$esteem)

cor.test(NegoResulftPlusEsteem$ResultChange,NegoResulftPlusEsteem$esteem, method = "pearson")
cor.test(NegoResulftPlusEsteem$ResultChange,NegoResulftPlusEsteem$esteem, method="kendall")
Model<-lm(ResultChange~esteem, data=NegoResulftPlusEsteem,na.action = na.exclude)
summary(Model)

######### stop redireting output.
sink()
cat("\nOutput of the analysis can be found back in file output_mainstudy_dataPreparationII.txt")

